﻿$(document).ready(function () {
    $(document).imagesLoaded(function () {
        initializeDragDrops();

        $(".dragDropAnswerList").each(function () {
            var container = $(this).closest(".questionContent");
            var choiceList = $(".dragDropChoiceList", container);

            if ($(this).outerHeight(true) < choiceList.outerHeight(true)) {
                stickyDragDropList($(this));
                setAnswerListPosition($(this));
            }
        });
    });
});

function stickyDragDropList(list) {
    var pos = list.offset();
    var container = list.closest(".questionContent");
    var bottom = (container.offset().top + container.outerHeight(true)) - list.outerHeight(true);

    $(window).scroll(function () {
        var scrollTop = $(document).scrollTop();
        list.toggleClass("stick", scrollTop >= pos.top && scrollTop < bottom);
    });

    $(window).resize(function () {
        setAnswerListPosition(list);
    });
}

function setAnswerListPosition(list) {
    var container = list.closest(".questionContent");
    var choiceList = $(".dragDropChoiceList", container);
    list.css("left", choiceList.offset().left + choiceList.outerWidth(true));
}

function initializeDragDrops() {
    $(".dragDropRanking").disableSelection();

    var checkDisableSort = function (list) {
        var ranking = list.closest(".dragDropRanking");
        var maxAnswers = ranking.attr("data-maxAnswers");

        if (maxAnswers) {
            if (list.hasClass("dragDropAnswerList")) {
                if (list.find("li").length == parseInt(maxAnswers)) {
                    $(".dragDropChoiceList", ranking).sortable("disable");
                }
            }
        }
    }

    $(".dragDropList").sortable({
        forcePlaceholderSize: true,
        forceHelperSize: true,
        cursor: "move",
        connectWith: ".dragDropList",
        tolerance: "pointer",
        placeholder: "dragDropHighlight",
        cancel: ".disabled",
        create: function (event, ui) {
            SetListInitialDimensions($(this));
        },
        start: function (event, ui) {
            var ranking = $(this).closest(".dragDropRanking");
            if ($(this).hasClass("dragDropAnswerList") && $(".dragDropChoiceList", ranking).hasClass("ui-sortable-disabled")) {
                $(".dragDropChoiceList", ranking).sortable("enable");
                $(this).sortable("refresh");
            }
        },
        stop: function (event, ui) {
            checkDisableSort($(this));
        },
        receive: function (event, ui) {
            checkDisableSort($(this));
        },
        over: function (event, ui) {
            var lastItem = $(".dragDropItem", $(this)).last();
            if (lastItem.length > 0) {
                if (ui.position.top > lastItem.position().top) {
                    $(ui.placeholder).appendTo(this);
                }
            }
        }
    });

    $(".dragDropList").each(function () {
        $(this).sortable("option", "containment", $(this).closest(".dragDropRanking"));
    });

    $(".dragDropList").on("sortupdate", function (event, ui) {
        UpdateValue($(this));
    });
}

function UpdateValue(list) {
    var container = list.closest(".dragDropRanking");
    var selectedAnswersList = $(".dragDropAnswerList", container);
    var selectedAnswers = $(".dragDropItem", selectedAnswersList);
    var maxAnswers = selectedAnswersList.attr("data-maxanswers");

    if (maxAnswers)
        $(".dragDropChoiceList .dragDropItem", container).toggleClass("disabled", selectedAnswers.length >= maxAnswers);

    var value = selectedAnswers.map(function () {
        return $(this).attr("data-choicevalue");
    }).get().join();

    $(".dragDropValue", container).val(value).trigger("change");
}

function SetListInitialDimensions(list) {
    var container = list.closest(".dragDropRanking");
    var questionContent = container.closest(".questionContent");

    questionContent.css({ width: "" });

    var numberOfCards = parseInt(list.attr("data-maxanswers"));

    if (!numberOfCards) {
        numberOfCards = $(".dragDropItem:visible", container).length;
    }

    var card = $(".dragDropItem", container).first();

    if (container.hasClass("horizontal")) {
        list.width(card.outerWidth(true) * numberOfCards);
        list.height(card.outerHeight(true));
    }
    else {
        list.width(card.outerWidth(true));
        list.height((card.outerHeight() * numberOfCards) + (2 * (numberOfCards + 1)));
    }

    $(".dragDropItem .textDiv", list).each(function () {
        var top = (card.height() / 2) - ($(this).height() / 2);
        if (top > 0) {
            $(this).css("top", top + "px");
        }
    });

    questionContent.width(questionContent.width());
}